#pragma once



// CSingleEntry-Befehlsziel

class CSingleEntry : public CObject
{
  protected:
	CString FEntryName;
	CSingleEntry* ParentList;	
public:
	CSingleEntry();
	CSingleEntry(const CString EName);
	CSingleEntry(const CString EName, CSingleEntry* Parent);
	virtual ~CSingleEntry();
public:
	CString EntryName() { return FEntryName; }
	CString FullName();
	virtual CString GetDisplayName();
	virtual CSingleEntry* FindEntry(const CString PartialName);
	virtual CSingleEntry* AddEntry(const CString EName);
	virtual CSingleEntry* AddNode(const CString NName);
	virtual CSingleEntry* GetEntry(int Index) { return NULL; }
};

class CListEntry : public CSingleEntry
{
private:
	CObArray EntryList;
public:
    CListEntry();
    CListEntry(const CString EName);
    CListEntry(const CString EName, CSingleEntry* Parent);
	virtual ~CListEntry();

	virtual CString GetDisplayName();
	virtual CSingleEntry* FindEntry(const CString PartialName);
	virtual CSingleEntry* AddEntry(const CString EName);
	virtual CSingleEntry* AddNode(const CString NName);
	virtual CSingleEntry* GetEntry(int Index);


};